/******************** (C) COPYRIGHT 2006 STMicroelectronics ********************
* File Name          : main.c
* Author             : MCD Application Team
* Date First Issued  : 11/27/2006  :   Version V1.0
* Description        : main program for Memory to UART DMA example
********************************************************************************
* History:
* 11/27/2006  :   Version V1.0
********************************************************************************
* THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
* WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE TIME.
* AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY DIRECT,
* INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING FROM THE
* CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE CODING
* INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
*******************************************************************************/

/* Includes ------------------------------------------------------------------*/
#include "91x_lib.h"

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/

/* Private typedef -----------------------------------------------------------*/

typedef struct
{
 u32 LLI_SrcAdd;    /* Source address of the data to be transferred.*/

 u32 LLI_DesAdd;   /* Destination address of the data to be transferred.*/

 u32 LLI_Pointer; /* Pointer to the next LLI. */

 u32 LLI_CCR;    /* the control word. */

} LLI_InitTypeDef;

/* Private variables ---------------------------------------------------------*/

DMA_InitTypeDef  DMA_InitStruct;
UART_InitTypeDef UART_InitStructure;
LLI_InitTypeDef LLI1_InitStructure, LLI2_InitStructure;
u8 TxBuffer0[12] = "UART example";
u8 TxBuffer1[6] =" using";
u8 TxBuffer2[12] =" Linked List";
  
/* Private function prototypes -----------------------------------------------*/

void SCU_Configuration(void);
void GPIO_Configuration(void);

/* Private functions ---------------------------------------------------------*/

/*******************************************************************************
* Function Name  : main
* Description    : Main program
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/


int main()

{
  #ifdef DEBUG
    debug();
  #endif

  /* Configure the system clocks */
  SCU_Configuration();

  /* Configure the GPIO ports */
  GPIO_Configuration();

  /* UART0 configuration -----------------------------------------------------*/
 
  UART_InitStructure.UART_WordLength = UART_WordLength_7D;
  UART_InitStructure.UART_StopBits = UART_StopBits_2;
  UART_InitStructure.UART_Parity = UART_Parity_No ;
  UART_InitStructure.UART_BaudRate = 115200;
  UART_InitStructure.UART_HardwareFlowControl = UART_HardwareFlowControl_None ;
  UART_InitStructure.UART_Mode = UART_Mode_Tx_Rx;
  UART_InitStructure.UART_FIFO = UART_FIFO_Enable;
  
  /* FIFO size 16 bytes, FIFO level 8 bytes */
  UART_InitStructure.UART_TxFIFOLevel = UART_FIFOLevel_1_2;
  
  /* FIFO size 16 bytes, FIFO level 8 bytes */
  UART_InitStructure.UART_RxFIFOLevel = UART_FIFOLevel_1_2; 

  UART_DeInit(UART0);
  UART_Init(UART0, &UART_InitStructure);
  
  /* Enable the DMA request for the Tx FIFO */
  UART_DMACmd(UART0,  UART_DMAReq_Tx , ENABLE);

  /* Enable the UART0 */
  UART_Cmd(UART0, ENABLE);

  while(UART_GetFlagStatus(UART0, UART_FLAG_TxFIFOFull) !=RESET);

  
  /***********************************VIC Configuration ***********************/
   
   VIC_DeInit();
   VIC_Config(DMA_ITLine, VIC_IRQ, 0);
   VIC_ITCmd(DMA_ITLine, ENABLE);


  /*******************************Linked list items for the second Link LLI****/
   
   LLI1_InitStructure.LLI_SrcAdd=(u32)(&TxBuffer1[0]);
   LLI1_InitStructure.LLI_DesAdd=(u32)(&UART0->DR); 
   LLI1_InitStructure.LLI_Pointer=(u32)(&(LLI2_InitStructure));
   LLI1_InitStructure.LLI_CCR=0x84000006;
   
   
   
  /************************Linked list items for the third Link LLI************/
   
   LLI2_InitStructure.LLI_SrcAdd=(u32)(&TxBuffer2[0]);
   LLI2_InitStructure.LLI_DesAdd=(u32)((&UART0->DR));
   LLI2_InitStructure.LLI_Pointer=0x00000000;
   LLI2_InitStructure.LLI_CCR=0x8400000C;
  
 
  /***************************** DMA Config ***********************************/
 
  /* DMA default configuration : Reset configuration*/
  DMA_DeInit(); 
  
  /*Enable the DMA*/
  DMA_Cmd(ENABLE);
  
  DMA_StructInit(&DMA_InitStruct);
   
  /* Write the first LLI*/
  
  /*Set the addresses of next linked list for the first LLI structure*/
  DMA_InitStruct.DMA_Channel_LLstItm=(u32)(&(LLI1_InitStructure.LLI_SrcAdd));
 
  /* Source address for the first LLI structure */
  DMA_InitStruct.DMA_Channel_SrcAdd=(u32)(&TxBuffer0[0]); 
  
  /*Destination address for the first LLI structure */
  DMA_InitStruct.DMA_Channel_DesAdd=(u32)(&UART0->DR); 
  
  /* The source bus width is one Byte*/
  DMA_InitStruct.DMA_Channel_SrcWidth= DMA_SrcWidth_Byte;
  
  /* The Destination bus width is one Byte*/
  DMA_InitStruct.DMA_Channel_DesWidth= DMA_DesWidth_Byte; 
  
  /* DMA  burst size of 4 data*/
  DMA_InitStruct.DMA_Channel_DesBstSize = DMA_DesBst_4Data ; 
  
  /* DMAC is The flow controller*/
  DMA_InitStruct.DMA_Channel_FlowCntrl=DMA_FlowCntrl1_DMA;
  DMA_InitStruct.DMA_Channel_Des= DMA_DES_UART0_TX;
  
  /*Transfer size of 12 data*/
  DMA_InitStruct.DMA_Channel_TrsfSize =12; 
  
  /*Incrementing source*/
  DMA_ChannelSRCIncConfig (DMA_Channel0, ENABLE);
  
  /*Enable the TCI interrupt for the first LLI*/
  DMA_ITConfig(DMA_Channel0, ENABLE);
  
  /*Enable the TCI interrupt for channel0*/
  DMA_ITMaskConfig(DMA_Channel0, DMA_ITMask_ITC, ENABLE);
  
  /* Update the DMA channel0 registers with the cfirst LLI structure*/
  DMA_Init(DMA_Channel0,&DMA_InitStruct);
  
  /*Enable the DMA channel0*/
  DMA_ChannelCmd (DMA_Channel0,ENABLE);
  
  /*infinite loop*/
  while(1);   
}

/*******************************************************************************
* Function Name  : SCU_Configuration
* Description    : Configures the system clocks.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SCU_Configuration(void)
{

  /* Enable the UART0 Clock */
  SCU_APBPeriphClockConfig(__UART0, ENABLE);

  /* Enable the GPIO2 Clock */
  SCU_APBPeriphClockConfig(__GPIO2, ENABLE);

  /* Enable the GPIO3 Clock */
  SCU_APBPeriphClockConfig(__GPIO3, ENABLE);

  /* Enable the GPIO5 Clock */
  SCU_APBPeriphClockConfig(__GPIO5, ENABLE);
  
  /*Enable VIC clock*/
  SCU_AHBPeriphClockConfig(__VIC,ENABLE);
  SCU_AHBPeriphReset(__VIC,DISABLE); 
  
  /* Enable the clock for DMA*/
  SCU_AHBPeriphClockConfig(__DMA,ENABLE); 

}

/*******************************************************************************
* Function Name  : GPIO_Configuration
* Description    : Configures the different GPIO ports.
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void GPIO_Configuration(void)
{
  GPIO_InitTypeDef GPIO_InitStructure;

  /*Configure UART0_CTS P2.0*/
  GPIO_DeInit(GPIO2);
  /*After DeInit function P2.0 = UART0_CTS (defaut configuration)*/

  GPIO_DeInit(GPIO5);
  /*Gonfigure UART0_Rx pin GPIO5.1*/
  GPIO_InitStructure.GPIO_Direction = GPIO_PinInput;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull ;
  GPIO_InitStructure.GPIO_IPConnected = GPIO_IPConnected_Enable;
  GPIO_InitStructure.GPIO_Alternate = GPIO_InputAlt1  ;
  GPIO_Init (GPIO5, &GPIO_InitStructure);

   GPIO_DeInit(GPIO3);
  /*Gonfigure UART0_Tx pin GPIO3.4*/
  GPIO_InitStructure.GPIO_Direction = GPIO_PinInput;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_4;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull ;
  GPIO_InitStructure.GPIO_Alternate = GPIO_OutputAlt3  ;
  GPIO_Init (GPIO3, &GPIO_InitStructure);

  /*Gonfigure UART0_RTS pin GPIO3.3*/
  GPIO_InitStructure.GPIO_Direction = GPIO_PinOutput;
  GPIO_InitStructure.GPIO_Pin = GPIO_Pin_3;
  GPIO_InitStructure.GPIO_Type = GPIO_Type_PushPull ;
  GPIO_InitStructure.GPIO_IPConnected = GPIO_IPConnected_Enable;
  GPIO_InitStructure.GPIO_Alternate = GPIO_OutputAlt3  ;
  GPIO_Init (GPIO3, &GPIO_InitStructure);
}

/******************* (C) COPYRIGHT 2006 STMicroelectronics *****END OF FILE****/

